import asyncio
import concurrent
import requests

#Requests
def readpage_blocking(port):
    r = requests.get("http://localhost:"+str(port))    
    return set(int(x) for x in r.text.split(','))

def writepage_blocking(port, port_to_write):
    r = requests.get("http://localhost:"+str(port)+"/new?port="+str(port_to_write))    


#Threads to avoid blockage on requests.get
class PageReader(object):
    def __init__(self, no_workers, rp=readpage_blocking, wp=writepage_blocking):
        self.tp_executor = concurrent.futures.ThreadPoolExecutor(max_workers=no_workers)
        self.rp=rp
        self.wp=wp
    async def readpage(self, port):
        return await asyncio.get_running_loop().run_in_executor(self.tp_executor, self.rp, port)

    async def writepage(self, port, port_to_write):
        await asyncio.get_running_loop().run_in_executor(self.tp_executor, self.wp, port,          
                                                port_to_write)

#Actual coroutines
async def complete_neighbourhood(start, pr=PageReader(100)):
    ports = await pr.readpage(start)
    tasks = (pr.writepage(port1, port2) 
                for port1 in ports for port2 in ports if port1!=port2)
    await asyncio.gather(*tasks)

async def climb_degree(start, pr=PageReader(100)):
    ports = await pr.readpage(start)
    current = (start, ports)
    while True:
        tasks = (pr.readpage(port) for port in current[1])
        lists = await asyncio.gather(*tasks)        
        candidates = zip(current[1], lists)
        key_fun = lambda x:(len(x[1]),-x[0])
        best = max(candidates, key=key_fun)
        if key_fun(best) <= key_fun(current):
            return current[0]
        current = best

#Fixed _dist value is not helpfull.Let's unfix it, it will make testing easier.
async def distance4(start, _dist=4, pr=PageReader(100)):
    done = {start}
    to_do = set(await pr.readpage(start)) - done    
    for _ in range(_dist-1):
        tasks = (pr.readpage(port) for port in to_do)
        done = done | to_do
        to_do = set.union(*await asyncio.gather(*tasks)) - done
        if not to_do: break
    return to_do
